/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: MoreVxdWraps.cpp,v 1.1 1999/09/12 04:33:31 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "MoreVxdWraps.h"

_USING_PGP

// Wrappers

void 
Exec_VxD_Int(UINT interrupt, VxdIntRegs *pRegs)
{
	pgpAssertAddrValid(pRegs, VxdIntRegs);

	_asm
	{
		pushad							; save current regs

		mov	edx, pRegs					; get address of input regs

		push	[edx].flags				; prepare input flags
		popfd

		mov	eax, [edx].eax				; prepare the input regs
		mov	ebx, [edx].ebx
		mov	ecx, [edx].ecx
		mov	edi, [edx].edi
		mov	esi, [edx].esi
		mov	edx, [edx].edx

		push	interrupt				; push interrupt number
		VMMCall(Exec_VxD_Int)			; execute the interrupt

		push	edx						; save edx
		mov	edx, pRegs					; load regs structure into edx
		pop	[edx].edx					; store the saved edx

		pushfd							; push the flags
		pop [edx].flags					; store the pushed flags

		mov	[edx].eax, eax				; store the altered regs
		mov	[edx].ebx, ebx
		mov	[edx].ecx, ecx
		mov	[edx].esi, esi
		mov	[edx].edi, edi

		popad							; restore current regs
	}
}

void 
NAKED 
_cdecl 
_GlobalTimeoutCallback()
{
	_asm
	{
		push	ecx
		push	[edx]GlobalTimeoutThunk.refData
		push	ebp
		push	ebx
		call	[edx]GlobalTimeoutThunk.callback
		add		esp, 16
		ret
	}
}

void 
NAKED 
_cdecl 
_RestrictedEventCallback()
{
	_asm
	{
		push	ecx
		push	[edx]RestrictedEventThunk.refData
		push	ebp
		push	ebx
		call	[edx]RestrictedEventThunk.callback
		add		esp, 16
		cld
		ret
	}
}
